<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'title',
    'value',
    'icon' => null,
    'trend' => null, // 'up', 'down', or null
    'trendValue' => null,
    'color' => 'gold' // gold, orange, peach, green, red
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'title',
    'value',
    'icon' => null,
    'trend' => null, // 'up', 'down', or null
    'trendValue' => null,
    'color' => 'gold' // gold, orange, peach, green, red
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
$colorClasses = [
    'gold' => 'from-amber-400 to-amber-500',
    'orange' => 'from-orange-400 to-orange-500',
    'peach' => 'from-orange-300 to-orange-400',
    'green' => 'from-green-400 to-green-500',
    'red' => 'from-red-400 to-red-500',
    'blue' => 'from-blue-400 to-blue-500',
];
$bgClass = $colorClasses[$color] ?? $colorClasses['gold'];
?>

<div class="glass-card-white p-6 rounded-3xl shadow-lg hover:shadow-xl transition-all duration-300 animate-fade-in-up">
    <div class="flex items-center justify-between mb-3">
        <div class="bg-gradient-to-br <?php echo e($bgClass); ?> p-3 rounded-2xl">
            <?php if($icon): ?>
                <?php echo $icon; ?>

            <?php else: ?>
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                </svg>
            <?php endif; ?>
        </div>
        
        <?php if($trend): ?>
            <span class="badge <?php echo e($trend === 'up' ? 'badge-success' : 'badge-danger'); ?>">
                <?php if($trend === 'up'): ?>
                    ↑
                <?php else: ?>
                    ↓
                <?php endif; ?>
                <?php echo e($trendValue); ?>

            </span>
        <?php endif; ?>
    </div>
    
    <p class="text-gray-600 text-sm font-medium mb-1"><?php echo e($title); ?></p>
    <h4 class="text-3xl font-bold text-gray-800"><?php echo e($value); ?></h4>
    
    <?php if(isset($footer)): ?>
        <div class="mt-3 pt-3 border-t border-gray-100">
            <?php echo e($footer); ?>

        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/components/stat-card-modern.blade.php ENDPATH**/ ?>