<?php
    // Calculate trends for stat cards
    $yesterday = \Carbon\Carbon::yesterday();
    $yesterdaySales = \App\Models\Order::whereDate('created_at', $yesterday)
        ->where('status', 'completed')
        ->sum('total');
    
    $salesTrend = $yesterdaySales > 0 ? (($dailySales - $yesterdaySales) / $yesterdaySales) * 100 : 0;
    $salesTrendDirection = $salesTrend >= 0 ? 'up' : 'down';
    
    // Calculate completion percentages for circular indicators
    $totalProducts = \App\Models\Product::count();
    $activeProducts = \App\Models\Product::where('status', 'active')->count();
    $activePercentage = $totalProducts > 0 ? round(($activeProducts / $totalProducts) * 100) : 0;
    
    $totalOrders = \App\Models\Order::count();
    $completedOrders = \App\Models\Order::where('status', 'completed')->count();
    $completionRate = $totalOrders > 0 ? round(($completedOrders / $totalOrders) * 100) : 0;
    
    $stockPercentage = 100 - min(100, ($lowStockCount / max(1, $totalProducts)) * 100);
?>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
            <div>
                <h2 class="font-display text-3xl font-bold text-bakery-dark-deep">
                    Panel de Control
                </h2>
                <p class="text-sm text-gray-600 mt-1">Resumen general de tu negocio</p>
            </div>
            <button class="btn-secondary" onclick="refreshDashboard()">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                </svg>
                Actualizar
            </button>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            
            
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 mb-8">
                
                
                <div class="lg:col-span-5">
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'glass']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'glass']); ?>
                        <div class="flex justify-between items-center mb-4">
                            <div>
                                <h3 class="text-lg font-bold text-bakery-dark">Ventas Mensuales</h3>
                                <p class="text-sm text-gray-500">Últimos 7 días</p>
                            </div>
                            <button class="px-3 py-1 bg-bakery-gold text-white rounded-full text-xs font-semibold hover:bg-bakery-secondary transition-colors">
                                Este Mes ▼
                            </button>
                        </div>
                        <div class="relative h-64">
                            <canvas id="salesBarChart"></canvas>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>
                
                
                <div class="lg:col-span-4 space-y-4">
                    <?php if (isset($component)) { $__componentOriginal6d74059c34730cb2c742dae13948a701 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6d74059c34730cb2c742dae13948a701 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.metric-card','data' => ['label' => 'Ventas del Día','value' => ($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format($dailySales, 2),'color' => 'success']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('metric-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['label' => 'Ventas del Día','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format($dailySales, 2)),'color' => 'success']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6d74059c34730cb2c742dae13948a701)): ?>
<?php $attributes = $__attributesOriginal6d74059c34730cb2c742dae13948a701; ?>
<?php unset($__attributesOriginal6d74059c34730cb2c742dae13948a701); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6d74059c34730cb2c742dae13948a701)): ?>
<?php $component = $__componentOriginal6d74059c34730cb2c742dae13948a701; ?>
<?php unset($__componentOriginal6d74059c34730cb2c742dae13948a701); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginal6d74059c34730cb2c742dae13948a701 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6d74059c34730cb2c742dae13948a701 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.metric-card','data' => ['label' => 'Pedidos Totales','value' => ($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format(\App\Models\Order::sum('total'), 2),'color' => 'info']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('metric-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['label' => 'Pedidos Totales','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(($globalSettings['currency_symbol'] ?? '$') . ' ' . number_format(\App\Models\Order::sum('total'), 2)),'color' => 'info']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6d74059c34730cb2c742dae13948a701)): ?>
<?php $attributes = $__attributesOriginal6d74059c34730cb2c742dae13948a701; ?>
<?php unset($__attributesOriginal6d74059c34730cb2c742dae13948a701); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6d74059c34730cb2c742dae13948a701)): ?>
<?php $component = $__componentOriginal6d74059c34730cb2c742dae13948a701; ?>
<?php unset($__componentOriginal6d74059c34730cb2c742dae13948a701); ?>
<?php endif; ?>
                    
                    
                    <div class="flex gap-2">
                        <a href="<?php echo e(route('pos.index')); ?>" class="flex-1 px-4 py-2 bg-gradient-to-r from-green-500 to-green-600 text-white rounded-xl text-sm font-semibold text-center hover:shadow-lg transition-all">
                            Nueva Venta
                        </a>
                        <a href="<?php echo e(route('production.create')); ?>" class="flex-1 px-4 py-2 bg-gradient-to-r from-purple-500 to-purple-600 text-white rounded-xl text-sm font-semibold text-center hover:shadow-lg transition-all">
                            Producir
                        </a>
                    </div>
                </div>
                
                
                <div class="lg:col-span-3 grid grid-cols-3 lg:grid-cols-1 gap-4">
                    <?php if (isset($component)) { $__componentOriginal964f412edd06b1e9f7f056b84f94533f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal964f412edd06b1e9f7f056b84f94533f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.circular-progress','data' => ['percentage' => $activePercentage,'color' => 'success','label' => 'Productos Activos','size' => 'md']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('circular-progress'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['percentage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($activePercentage),'color' => 'success','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Productos Activos'),'size' => 'md']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $attributes = $__attributesOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $component = $__componentOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__componentOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginal964f412edd06b1e9f7f056b84f94533f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal964f412edd06b1e9f7f056b84f94533f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.circular-progress','data' => ['percentage' => $completionRate,'color' => 'info','label' => 'Tasa de Completado','size' => 'md']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('circular-progress'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['percentage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($completionRate),'color' => 'info','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Tasa de Completado'),'size' => 'md']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $attributes = $__attributesOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $component = $__componentOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__componentOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginal964f412edd06b1e9f7f056b84f94533f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal964f412edd06b1e9f7f056b84f94533f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.circular-progress','data' => ['percentage' => round($stockPercentage),'color' => 'warning','label' => 'Stock Saludable','size' => 'md']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('circular-progress'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['percentage' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(round($stockPercentage)),'color' => 'warning','label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Stock Saludable'),'size' => 'md']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $attributes = $__attributesOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__attributesOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal964f412edd06b1e9f7f056b84f94533f)): ?>
<?php $component = $__componentOriginal964f412edd06b1e9f7f056b84f94533f; ?>
<?php unset($__componentOriginal964f412edd06b1e9f7f056b84f94533f); ?>
<?php endif; ?>
                </div>
            </div>

            
            <div class="grid grid-cols-1 lg:grid-cols-8 gap-6 mb-8">
                
                
                <div class="lg:col-span-5">
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'glass']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'glass']); ?>
                        <div class="mb-4">
                            <h3 class="text-lg font-bold text-bakery-dark mb-1">Tendencia de Ventas & Órdenes</h3>
                            <p class="text-xs text-gray-500">Comparativa últimos 7 días</p>
                        </div>
                        <div class="relative h-80">
                            <canvas id="multiLineChart"></canvas>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>
                
                
                <div class="lg:col-span-3 space-y-4">
                    
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'bordered']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'bordered']); ?>
                        <h3 class="font-bold text-bakery-dark mb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-bakery-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                            </svg>
                            Tareas Pendientes
                        </h3>
                        <div class="space-y-3">
                            <div class="flex items-center gap-3 p-2 hover:bg-gray-50 rounded-lg transition-colors">
                                <div class="w-3 h-3 rounded-full bg-green-500 flex-shrink-0"></div>
                                <span class="text-sm text-gray-700 flex-1">Revisar inventario bajo</span>
                                <input type="checkbox" class="rounded border-gray-300 text-bakery-gold focus:ring-bakery-gold">
                            </div>
                            <div class="flex items-center gap-3 p-2 hover:bg-gray-50 rounded-lg transition-colors">
                                <div class="w-3 h-3 rounded-full bg-green-500 flex-shrink-0"></div>
                                <span class="text-sm text-gray-700 flex-1">Actualizar precios</span>
                                <input type="checkbox" class="rounded border-gray-300 text-bakery-gold focus:ring-bakery-gold">
                            </div>
                            <div class="flex items-center gap-3 p-2 hover:bg-gray-50 rounded-lg transition-colors">
                                <div class="w-3 h-3 rounded-full bg-purple-500 flex-shrink-0"></div>
                                <span class="text-sm text-gray-700 flex-1">Preparar producción</span>
                                <input type="checkbox" class="rounded border-gray-300 text-bakery-gold focus:ring-bakery-gold">
                            </div>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>

                    
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'bordered']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'bordered']); ?>
                        <h3 class="font-bold text-bakery-dark mb-4">Metas del Mes</h3>
                        <div class="space-y-4">
                            
                            <div>
                                <div class="flex justify-between items-center mb-2">
                                    <span class="text-sm text-gray-600">Meta de Ventas</span>
                                    <span class="text-sm font-bold text-gray-800">64%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-3">
                                    <div class="bg-gradient-to-r from-yellow-400 to-yellow-500 h-3 rounded-full shadow-md" style="width: 64%"></div>
                                </div>
                            </div>
                            
                            
                            <div>
                                <div class="flex justify-between items-center mb-2">
                                    <span class="text-sm text-gray-600">Meta de Producción</span>
                                    <span class="text-sm font-bold text-gray-800">83%</span>
                                </div>
                                <div class="w-full bg-gray-200 rounded-full h-3">
                                    <div class="bg-gradient-to-r from-yellow-400 to-yellow-500 h-3 rounded-full shadow-md" style="width: 83%"></div>
                                </div>
                            </div>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>
            </div>

            
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-6">
                
                
                <div class="lg:col-span-3">
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'glass']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'glass']); ?>
                        <div class="mb-4">
                            <h3 class="font-bold text-bakery-dark">Ventas por Categoría</h3>
                            <p class="text-xs text-gray-500 mt-1">Top 5 categorías</p>
                        </div>
                        <div class="relative h-56">
                            <canvas id="categoryDonutChart"></canvas>
                        </div>
                        <div class="mt-4 space-y-2">
                            <div class="flex justify-between text-xs">
                                <span class="text-gray-600">Ipsum dolor</span>
                                <span class="font-semibold">34%</span>
                            </div>
                            <div class="flex justify-between text-xs">
                                <span class="text-gray-600">Dolor sit</span>
                                <span class="font-semibold">36%</span>
                            </div>
                            <div class="flex justify-between text-xs">
                                <span class="text-gray-600">Amet lorem</span>
                                <span class="font-semibold">12%</span>
                            </div>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>

                
                <div class="lg:col-span-5">
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'bordered']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'bordered']); ?>
                        <h3 class="font-bold text-bakery-dark mb-4 flex items-center">
                            <svg class="w-5 h-5 mr-2 text-bakery-gold" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                            Actividad Reciente
                        </h3>
                        <div class="space-y-3">
                            <?php $__empty_1 = true; $__currentLoopData = $recentOrders->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="p-3 bg-gradient-to-r from-bakery-cream to-bakery-cream/50 rounded-lg hover:shadow-md transition-shadow border border-bakery-gold/20">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <p class="text-sm font-semibold text-bakery-dark">
                                                <?php echo e($order->customer->name ?? 'Cliente Anónimo'); ?>

                                            </p>
                                            <p class="text-xs text-gray-600">
                                                Orden #<?php echo e($order->id); ?>

                                            </p>
                                        </div>
                                        <div class="text-right">
                                            <p class="text-sm font-bold text-green-600">
                                                <?php echo e($globalSettings['currency_symbol'] ?? '$'); ?><?php echo e(number_format($order->total, 2)); ?>

                                            </p>
                                            <span class="badge badge-<?php echo e($order->status === 'completed' ? 'success' : 'warning'); ?> text-xs">
                                                <?php echo e(ucfirst($order->status)); ?>

                                            </span>
                                        </div>
                                    </div>
                                    <p class="text-xs text-gray-500 mt-1">
                                        <?php echo e($order->created_at->diffForHumans()); ?>

                                    </p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-center py-8 text-gray-500">
                                    <p class="text-sm">No hay órdenes recientes</p>
                                </div>
                            <?php endif; ?>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>

                
                <div class="lg:col-span-4">
                    <?php if (isset($component)) { $__componentOriginalfc34df8c041cfce1b125f68563b94330 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfc34df8c041cfce1b125f68563b94330 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modern-card','data' => ['variant' => 'glass']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modern-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'glass']); ?>
                        <div class="mb-4">
                            <h3 class="font-bold text-bakery-dark">Ventas Semanales</h3>
                            <p class="text-xs text-gray-500 mt-1">Por día de la semana</p>
                        </div>
                        <div class="relative h-64">
                            <canvas id="weekBarChart"></canvas>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $attributes = $__attributesOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__attributesOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfc34df8c041cfce1b125f68563b94330)): ?>
<?php $component = $__componentOriginalfc34df8c041cfce1b125f68563b94330; ?>
<?php unset($__componentOriginalfc34df8c041cfce1b125f68563b94330); ?>
<?php endif; ?>
                </div>
            </div>

        </div>
    </div>

    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const currencySymbol = "<?php echo e($globalSettings['currency_symbol'] ?? '$'); ?>";
            const colors = {
                pink: '#ec4899',
                pinkLight: '#f9a8d4',
                yellow: '#fbbf24',
                green: '#10b981',
                greenLight: '#6ee7b7',
                purple: '#a855f7',
                blue: '#3b82f6',
                bakeryPrimary: '#D4965A',
                bakerySecondary: '#E9C46A'
            };

            // 1. Sales Bar Chart (Pink bars like in reference image)
            new Chart(document.getElementById('salesBarChart'), {
                type: 'bar',
                data: {
                    labels: <?php echo json_encode($salesLabels); ?>,
                    datasets: [{
                        label: 'Ventas',
                        data: <?php echo json_encode($salesData); ?>,
                        backgroundColor: colors.pink,
                        borderRadius: 8,
                        borderSkipped: false
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    return currencySymbol + ' ' + context.parsed.y.toFixed(2);
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { display: false },
                            ticks: {
                                callback: function(value) {
                                    return currencySymbol + value;
                                }
                            }
                        },
                        x: {
                            grid: { display: false }
                        }
                    }
                }
            });

            // 2. Multi-line Area Chart (Yellow & Green like in reference)
            new Chart(document.getElementById('multiLineChart'), {
                type: 'line',
                data: {
                    labels: <?php echo json_encode($salesLabels); ?>,
                    datasets: [
                        {
                            label: 'Ventas',
                            data: <?php echo json_encode($salesData); ?>,
                            borderColor: colors.yellow,
                            backgroundColor: 'rgba(251, 191, 36, 0.2)',
                            fill: true,
                            tension: 0.4,
                            pointRadius: 0,
                            borderWidth: 3
                        },
                        {
                            label: 'Órdenes',
                            data: [<?php echo e($totalOrders * 0.2); ?>, <?php echo e($totalOrders * 0.25); ?>, <?php echo e($totalOrders * 0.22); ?>, <?php echo e($totalOrders * 0.28); ?>, <?php echo e($totalOrders * 0.30); ?>, <?php echo e($totalOrders * 0.26); ?>, <?php echo e($totalOrders * 0.32); ?>],
                            borderColor: colors.green,
                            backgroundColor: 'rgba(16, 185, 129, 0.2)',
                            fill: true,
                            tension: 0.4,
                            pointRadius: 0,
                            borderWidth: 3
                        }
                    ]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: true,
                            position: 'top',
                            align: 'end',
                            labels: {
                                usePointStyle: true,
                                padding: 15,
                                font: { size: 12 }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { color: 'rgba(0,0,0,0.05)' }
                        },
                        x: {
                            grid: { display: false }
                        }
                    },
                    interaction: {
                        intersect: false,
                        mode: 'index'
                    }
                }
            });

            // 3. Category Donut Chart (Purple like in reference)
            new Chart(document.getElementById('categoryDonutChart'), {
                type: 'doughnut',
                data: {
                    labels: <?php echo json_encode($categoryLabels); ?>,
                    datasets: [{
                        data: <?php echo json_encode($categoryData); ?>,
                        backgroundColor: [
                            colors.purple,
                            colors.pink,
                            colors.blue,
                            colors.bakeryPrimary,
                            colors.green
                        ],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '70%',
                    plugins: {
                        legend: { display: false }
                    }
                }
            });

            // 4. Week Bar Chart (Pink bars)
            new Chart(document.getElementById('weekBarChart'), {
                type: 'bar',
                data: {
                    labels: ['L', 'M', 'M', 'J', 'V', 'S', 'D'],
                    datasets: [{
                        label: 'Ventas',
                        data: <?php echo json_encode($weekSalesData); ?>,
                        backgroundColor: colors.pink,
                        borderRadius: 8,
                        borderSkipped: false
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { display: false }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: { display: false },
                            ticks: {
                                callback: function(value) {
                                    return currencySymbol + value;
                                }
                            }
                        },
                        x: {
                            grid: { display: false }
                        }
                    }
                }
            });
        });

        function refreshDashboard() {
            location.reload();
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/dashboard.blade.php ENDPATH**/ ?>