<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'percentage' => 0,
    'color' => 'primary',
    'label' => '',
    'size' => 'md'
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'percentage' => 0,
    'color' => 'primary',
    'label' => '',
    'size' => 'md'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $sizeClasses = [
        'sm' => 'w-20 h-20',
        'md' => 'w-24 h-24',
        'lg' => 'w-32 h-32'
    ];
    
    $colorMap = [
        'primary' => '#D4965A',
        'secondary' => '#E9C46A',
        'success' => '#06D6A0',
        'warning' => '#F4A261',
        'danger' => '#EF476F',
        'info' => '#118AB2',
        'purple' => '#9333ea',
        'yellow' => '#eab308',
        'green' => '#22c55e'
    ];
    
    $strokeColor = $colorMap[$color] ?? $colorMap['primary'];
    $radius = 45;
    $circumference = 2 * pi() * $radius;
    $offset = $circumference - ($percentage / 100) * $circumference;
?>

<div class="flex flex-col items-center">
    <div class="relative <?php echo e($sizeClasses[$size] ?? $sizeClasses['md']); ?>">
        <svg class="w-full h-full transform -rotate-90" viewBox="0 0 100 100">
            <!-- Background circle -->
            <circle
                cx="50"
                cy="50"
                r="<?php echo e($radius); ?>"
                fill="none"
                stroke="#e5e7eb"
                stroke-width="8"
            />
            
            <!-- Progress circle -->
            <circle
                cx="50"
                cy="50"
                r="<?php echo e($radius); ?>"
                fill="none"
                stroke="<?php echo e($strokeColor); ?>"
                stroke-width="8"
                stroke-linecap="round"
                stroke-dasharray="<?php echo e($circumference); ?>"
                stroke-dashoffset="<?php echo e($offset); ?>"
                class="transition-all duration-1000 ease-out"
            />
        </svg>
        
        <!-- Percentage text -->
        <div class="absolute inset-0 flex items-center justify-center">
            <span class="text-2xl font-bold text-gray-800"><?php echo e($percentage); ?>%</span>
        </div>
    </div>
    
    <?php if($label): ?>
        <p class="mt-2 text-sm text-gray-600 text-center"><?php echo e($label); ?></p>
    <?php endif; ?>
</div>
<?php /**PATH C:\Webs\PHP\panaderiapasteleria\resources\views/components/circular-progress.blade.php ENDPATH**/ ?>